#include <config.h>

#if defined(CONFIG_RTL8390)
confcode_prv_t rtl8214fc_6276A_rtl8390_perchip_serdes[] = {
    /* Serdes */
    { 0, 0x1e, 8},
    { 0, 0x1f, 0x405}, { 0, 0x14, 0x8EC},     //# S0 default 0x8E4, bit 3 = 1 => S0 40 bit, 0 --- S0 20 bits.

    { 0, 0x1f, 0x404}, { 0, 0x17, 0x5359},//# S0 RXCLKWR change to neg edge

    { 0, 0x1f, 0x424}, { 0, 0x17, 0x5359},    //# S1 RXCLKWR change to neg edge

    //## Analog AFE patch
    { 0, 0x1f, 0x42C},     //# 0x2161 0x4000
    { 0, 0x11, 0x4000},
    { 0, 0x12, 0x2020},  //# S1 KI=0, KP = 3

    { 0, 0x1f, 0x42D},     //# 0x2169 0xC014
    { 0, 0x11, 0xC014},

    { 0, 0x1f, 0x464},     //# 0x2325 0x202a
    { 0, 0x15, 0x202a},     //Rsel = 10G/FF, kp1_1 = 2
    { 0, 0x12, 0x1fe0},    //#configure VGA=0x3

    { 0, 0x1f, 0x404},    // # 0x232a 0x40ff
    { 0, 0x10, 0x9703},

    { 0, 0x1f, 0x42E}, //    # 0x2171 0x218F
    { 0, 0x11, 0x218F},

    { 0, 0x1f, 0x044C}, //# 0x2261 = 0x4000, Turn off RING PLL
    { 0, 0x11, 0x4000},

    {0, 31, 0x0460}, {0, 0x10, 0x4800},
    {0, 31, 0x0462}, {0, 0x12, 0x96b3},
    {0, 0x15, 0x6e58},  //#enable cmu lbw for Icp
    {0, 31, 0x0464}, {0, 0x13, 0x3def}, {0, 0x16, 0xf072},
    {0, 31, 0x0465}, {0, 0x10, 0x4208}, {0, 0x11, 0x3a08}, {0, 0x12, 0x4007},

    {0, 31, 0x0464}, {0, 0x17, 0x84f5}, {0, 0x17, 0x04f5},
};

confcode_phy_patch_t rtl8214fc_6276A_rtl8390_perchip_serdes2[] = {
    {30, 15, 0, 0x8},
    //#15-11:Filter_0, 10-7:1=force, 0=calib
    {31, 15, 0, 0x0464},
    {0x12, 15, 11, 0x3},
    {0x12, 10, 7, 0xf},
    //#14-10:fitler_3, 9-5:filter_2, 4-0:filter_1
    {31, 15, 0, 0x0464},
    {0x13, 14, 10, 0xf},
    {0x13, 9, 5, 0x11},
    {0x13, 4, 0, 0x10},
    //#eanble offset calibration
    {31, 15, 0, 0x0462},
    {0x10, 13, 12, 0x3},
    //#2013/8/13, RL6276B S0,S1 disable impedance auto-calibration, force R=0x8;
    //#RL6276B S1 impedance was controlled by S0
    //#page.0x462,reg.0x13: [20]=0, [25]=0, [19:16]=0x8, [24:21]=0x8
    {31, 15, 0, 0x0462},
    {0x13, 15, 0, 0x5108},
};

confcode_prv_t rtl8214fc_6276A_rtl8390_perchip_serdes3[] = {
    /* cmu reset */
    {0, 31, 0x0467}, {0, 0x14, 0x143d}, {0, 0x14, 0x3c15}, {0, 0x14, 0x3c17}, {0, 0x14, 0x0},
    /* digital soft reset */
    {0, 31, 0x0404}, {0, 0x13, 0x7146}, {0, 0x13, 0x7106},

    { 0, 0x1f, 0x42D},//     # 0x2169 bit0 = S1 ana reset
    { 0, 0x11, 0xC015}, { 0, 0x11, 0xC014},

    { 0, 0x1e, 0},

    /* 18B serdes force qsgmii */
    {0, 30, 0x0008},
    {0, 31, 0x404 },
    {0, 20, 0xd749 },
    {0, 31, 0x424 },
    {0, 20, 0xd749 },

    { 0, 0x001e, 0x0000 },
};

confcode_rv_t rtl8214fc_6276A_rtl8390_perport[] = {\
    {0x1f, 0xa5d}, {0x10, 0x0},\
    {0x1e, 0x0001}, {0x1f, 0x0bc0}, {0x16, 0x0c00}, {0x1f, 0x0a43}, \
    {0x11, 0x0043}, \
    /* 1000M green short cable change viterbi from partial viterbi to full viterbi */
	{0x13, 0x809f}, {0x14, 0x6b20}, \
    {0x1e, 0x0000}, \
    /*8214FC fiber down speed patch*/
    {0x1e, 0x0003}, {0x1f, 0x0003}, {0x15, 0xE47F}, \
    {0x1f, 0x0009}, {0x15, 0x46F4}, {0x1e, 0x0000}, \
    };

confcode_prv_t rtl8214fc_6276A_rtl8390_fiber_perchip[] = {\
    {0, 0x1e, 0x0008}, {0, 0x1f, 0x0260}, {0, 0x14, 0x032c}, \
    {0, 0x1f, 0x0280}, {0, 0x10, 0xf0bb}, {0, 0x1f, 0x0266}, {0, 0x10, 0x0f95}, \
    {0, 0x13, 0x0f95}, {0, 0x14, 0x0f95}, {0, 0x15, 0x0f95}, {0, 0x1e, 0x0003}, \
    //fiber rx change to neg. edge 0x17
    //One Giga Nway disable linkon 0x14
    //130719 Disable fiber Fib100 down speed feature, default 0x0f20  0x11
    {0, 0x1f, 0x0008}, {0, 0x17, 0x5359}, {0, 0x14, 0x074D}, {0, 0x11, 0x0f00}, \
    {0, 0x1e, 0x0000}, {1, 0x1e, 0x0003}, \
    {1, 0x1f, 0x0008}, {1, 0x17, 0x5359}, {1, 0x14, 0x074D}, {1, 0x11, 0x0f00}, \
    {1, 0x1e, 0x0000}, {2, 0x1e, 0x0003}, \
    {2, 0x1f, 0x0008}, {2, 0x17, 0x5359}, {2, 0x14, 0x074D}, {2, 0x11, 0x0f00}, \
    {2, 0x1e, 0x0000}, {3, 0x1e, 0x0003}, \
    {3, 0x1f, 0x0008}, {3, 0x17, 0x5359}, {3, 0x14, 0x074D}, {3, 0x11, 0x0f00}, \
    {3, 0x1e, 0x0000} \
    };

confcode_prv_t rtl8214fc_0455B_rtl8390_perchip_serdes[] = {
    /* Serdes */
#if 1 /* QSGMII_MODE */
    { 0, 0x001d, 0x0008 }, { 0, 0x001f, 0x0460 }, { 0, 0x0010, 0xd800 }, { 0, 0x0011, 0x4000 },
    { 0, 0x0012, 0x5400 }, { 0, 0x0013, 0x7ffb }, { 0, 0x0014, 0x1f   }, { 0, 0x0015, 0x60c1 },
    { 0, 0x0016, 0x60c1 }, { 0, 0x0017, 0xffff }, { 0, 0x001f, 0x0461 }, { 0, 0x0010, 0xffff },
    { 0, 0x0011, 0xdc6f }, { 0, 0x0012, 0x1004 }, { 0, 0x0013, 0x14a5 }, { 0, 0x0014, 0xe514 },
    { 0, 0x0015, 0x514  }, { 0, 0x0016, 0x8a41 }, { 0, 0x0017, 0x48c0 }, { 0, 0x001f, 0x0462 },
    { 0, 0x0010, 0xf216 }, { 0, 0x0011, 0xf04a }, { 0, 0x0012, 0x97b3 }, { 0, 0x0013, 0xd10f },
    { 0, 0x0014, 0x0f03 }, { 0, 0x0015, 0x8060 }, { 0, 0x0016, 0x7860 }, { 0, 0x0017, 0xbdef },
    { 0, 0x001f, 0x0463 }, { 0, 0x0010, 0xffff }, { 0, 0x0011, 0xc60a }, { 0, 0x0012, 0xa052 },
    { 0, 0x0013, 0xf5   }, { 0, 0x0014, 0x4205 }, { 0, 0x0015, 0x7e19 }, { 0, 0x0016, 0x44a2 },
    { 0, 0x0017, 0xc3e0 }, { 0, 0x001f, 0x0464 }, { 0, 0x0010, 0x601c }, { 0, 0x001f, 0x0464 },
    { 0, 0x0011, 0xc9ae }, { 0, 0x0012, 0x87E0 }, { 0, 0x0013, 0x3df0 }, { 0, 0x0014, 0xffff },
    { 0, 0x0015, 0x7003 }, { 0, 0x0016, 0xf01a }, { 0, 0x0017, 0x04f5 }, { 0, 0x001f, 0x0465 },
    { 0, 0x0010, 0x41ff }, { 0, 0x0011, 0x39ff }, { 0, 0x0012, 0x4010 }, { 0, 0x0013, 0x7f   },
    { 0, 0x0014, 0x619f }, { 0, 0x0015, 0x29fb }, { 0, 0x0016, 0x7f60 }, { 0, 0x001f, 0x0467 },
    { 0, 0x0016, 0x60b  }, { 0, 0x0014, 0xfe3d }, { 0, 0x0014, 0xfe3f }, { 0, 0x001f, 0x0405 },
    { 0, 0x0014, 0x8ec  }, { 0, 0x001f, 0x042c }, { 0, 0x0010, 0xc003 }, { 0, 0x0011, 0xC000 },
    { 0, 0x0012, 0x3024 }, { 0, 0x0014, 0x4000 }, { 0, 0x0017, 0x34fe }, { 0, 0x001f, 0x042d },
    { 0, 0x0011, 0x4114 }, { 0, 0x0016, 0x201f }, { 0, 0x001f, 0x0464 }, { 0, 0x0017, 0x84f5 },
    { 0, 0x0017, 0x04f5 }, { 0, 0x001d, 0x0008 }, { 0, 0x001f, 0x0404 }, { 0, 0x0010, 0x9703 },

    { 0,   0x1f, 0x44c  }, { 0, 0x0010, 0xc003 }, { 0, 0x0011, 0xC000 }, { 0, 0x0012, 0x3024 },
    { 0, 0x0013, 0xA0C0 }, { 0, 0x0014, 0x4000 }, { 0, 0x0015, 0x9060 }, { 0, 0x0016, 0xFC00 },
    { 0, 0x0017, 0x34FE }, { 0,   0x1f, 0x44d  }, { 0, 0x0010, 0x7231 }, { 0, 0x0011, 0x4114 },
    { 0, 0x0012, 0x6978 }, { 0, 0x0013, 0x0844 }, { 0, 0x0014, 0x0004 }, { 0, 0x0015, 0x326A },
    { 0, 0x0016, 0x201F }, { 0, 0x0017, 0x115D }, { 0,   0x1f, 0x44e  }, { 0, 0x0010, 0x2ABD },
    { 0, 0x0011, 0x0000 }, { 0, 0x0012, 0x0000 }, { 0, 0x0013, 0x0000 }, { 0, 0x0014, 0x0000 },
    { 0, 0x0015, 0x0000 }, { 0, 0x0016, 0x0000 }, { 0, 0x0017, 0x0000 }, { 0,   0x1f, 0x44f  },
    { 0, 0x0010, 0x0015 }, { 0, 0x0011, 0xFFFF }, { 0, 0x0012, 0x0000 }, { 0, 0x0013, 0x0000 },
    { 0, 0x0014, 0x0000 }, { 0, 0x0015, 0x0000 }, { 0, 0x0016, 0x0000 }, { 0, 0x0017, 0x0000 },

    /* frc_qsgmii{} */
    { 0, 29, 0x8 },
    { 0, 31, 0x404 },
    { 0, 20, 0xd749 },
    { 0, 31, 0x444 },
    { 0, 20, 0xd749 },

    { 0, 0x001d, 0x0000 },
#else
    { 0, 0x001d, 0x0008 }, { 0, 0x001f, 0x0460 }, { 0, 0x0010, 0xd800 }, { 0, 0x0011, 0x4000 },
    { 0, 0x0012, 0x5400 }, { 0, 0x0013, 0x7ffb }, { 0, 0x0014, 0x1f   }, { 0, 0x0015, 0x60c1 },
    { 0, 0x0016, 0x60c1 }, { 0, 0x0017, 0xffff }, { 0, 0x001f, 0x0461 }, { 0, 0x0010, 0xffff },
    { 0, 0x0011, 0xdc6f }, { 0, 0x0012, 0x1004 }, { 0, 0x0013, 0x14a5 }, { 0, 0x0014, 0xe514 },
    { 0, 0x0015, 0x514  }, { 0, 0x0016, 0x8a41 }, { 0, 0x0017, 0x48c0 }, { 0, 0x001f, 0x0462 },
    { 0, 0x0010, 0xf216 }, { 0, 0x0011, 0xf04a }, { 0, 0x0012, 0x97b3 }, { 0, 0x0013, 0xd10f },
    { 0, 0x0014, 0x0f03 }, { 0, 0x0015, 0x8060 }, { 0, 0x0016, 0x7860 }, { 0, 0x0017, 0xbdef },
    { 0, 0x001f, 0x0463 }, { 0, 0x0010, 0xffff }, { 0, 0x0011, 0xc60a }, { 0, 0x0012, 0xa052 },
    { 0, 0x0013, 0xf5   }, { 0, 0x0014, 0x4205 }, { 0, 0x0015, 0x7e19 }, { 0, 0x0016, 0x44a2 },
    { 0, 0x0017, 0xc3e0 }, { 0, 0x001f, 0x0464 }, { 0, 0x0010, 0x601c }, { 0, 0x001f, 0x0464 },
    { 0, 0x0011, 0xc9ae }, { 0, 0x0012, 0x87E0 }, { 0, 0x0013, 0x3df0 }, { 0, 0x0014, 0xffff },
    { 0, 0x0015, 0x7003 }, { 0, 0x0016, 0xf01a }, { 0, 0x0017, 0x04f5 }, { 0, 0x001f, 0x0465 },
    { 0, 0x0010, 0x41ff }, { 0, 0x0011, 0x39ff }, { 0, 0x0012, 0x4010 }, { 0, 0x0013, 0x7f   },
    { 0, 0x0014, 0x619f }, { 0, 0x0015, 0x29fb }, { 0, 0x0016, 0x7f60 }, { 0, 0x001f, 0x0467 },
    { 0, 0x0016, 0x60b  }, { 0, 0x0014, 0xfe3d }, { 0, 0x0014, 0xfe3f }, { 0, 0x001f, 0x0405 },
    { 0, 0x0014, 0x8ec  }, { 0, 0x001f, 0x042c }, { 0, 0x0010, 0xc003 }, { 0, 0x0011, 0xc000 },
    { 0, 0x0012, 0x3024 }, { 0, 0x0014, 0x4000 }, { 0, 0x0017, 0x34fe }, { 0, 0x001f, 0x042d },
    { 0, 0x0011, 0x4114 }, { 0, 0x0016, 0x201f }, { 0, 0x001f, 0x0464 }, { 0, 0x0017, 0x84f5 },
    { 0, 0x0017, 0x04f5 },
    { 0, 0x001d, 0x0008 }, { 0, 0x001f, 0x0404 }, { 0, 0x0010, 0x9703 },
#endif
};

confcode_prv_t rtl8214fc_0455B_rtl8390_perchip[] = {
#if 1
    /* Chip */
    { 0, 0x1d, 0x0001 }, { 1, 0x1d, 0x0001 }, { 2, 0x1d, 0x0001 }, { 3, 0x1d, 0x0001 },
    { 0, 0x1f, 0x0a42 }, { 1, 0x1f, 0x0a42 }, { 2, 0x1f, 0x0a42 }, { 3, 0x1f, 0x0a42 },
    { 0, 0x1d, 0x0000 }, { 1, 0x1d, 0x0000 }, { 2, 0x1d, 0x0000 }, { 3, 0x1d, 0x0000 },
#endif
    /* set chip mode to 8214FC for SDK */
    { 0, 0x1f, 0x0a42 }, { 0, 29, 8 },
    { 0, 0x1f, 0x0278 }, { 0, 18, 0x0455 },
#if 1
    /* QSGMII */
    { 0, 0x1f, 0x0268 }, { 0, 22, 0x14 },
#else
    /* RSGMII-Plus */
    { 0, 0x1f, 0x0268 }, { 0, 22, 0x16 },
#endif
    { 0, 0x1f, 0x0260 }, { 0, 20, 0x023E },
    { 0, 0x1f, 0x0260 }, { 0, 21, 0x00f0 },
    { 0, 0x1f, 0x0261 }, { 0, 16, 0x300f },
    { 0, 0x1f, 0x0266 }, { 0, 16, 0x0f54 }, { 0, 19, 0x0f54 }, { 0, 20, 0x0f54 }, { 0, 21, 0x0f54 },
    { 0, 0x1f, 0x0a42 }, { 0, 29, 0 },
    };

confcode_rv_t rtl8214fc_0455B_rtl8390_perport[] = {
    {0x1d, 0x0001},
#if 1
    {0x1f, 0x0a43}, {0x13, 0x8146}, {0x14, 0x5501}, {0x13, 0xb82e},
    {0x14, 0x0001}, {0x1f, 0x0a43}, {0x13, 0xb820}, {0x14, 0x0090},
    {0x13, 0xa012}, {0x14, 0x0000}, {0x13, 0xa014}, {0x14, 0x2c04},
    {0x14, 0x2c8b}, {0x14, 0x2d3b}, {0x14, 0x2d40}, {0x14, 0xd705},
    {0x14, 0x40b2}, {0x14, 0xd70c}, {0x14, 0x4060}, {0x14, 0xd0f4},
    {0x14, 0xd187}, {0x14, 0xcc28}, {0x14, 0x165b}, {0x14, 0x1628},
    {0x14, 0x1630}, {0x14, 0xa37a}, {0x14, 0xd704}, {0x14, 0xd502},
    {0x14, 0xa301}, {0x14, 0xe01f}, {0x14, 0x0004}, {0x14, 0xa230},
    {0x14, 0x404a}, {0x14, 0xa240}, {0x14, 0xd500}, {0x14, 0xa901},
    {0x14, 0xd700}, {0x14, 0xa342}, {0x14, 0xc203}, {0x14, 0xd501},
    {0x14, 0x40de}, {0x14, 0xd302}, {0x14, 0x409e}, {0x14, 0xe060},
    {0x14, 0x0540}, {0x14, 0x2c25}, {0x14, 0xe060}, {0x14, 0x0520},
    {0x14, 0xd704}, {0x14, 0xc307}, {0x14, 0xc104}, {0x14, 0xa640},
    {0x14, 0x406c}, {0x14, 0xa906}, {0x14, 0xa901}, {0x14, 0xc2f0},
    {0x14, 0x312a}, {0x14, 0x5c32}, {0x14, 0xc2e0}, {0x14, 0x404a},
    {0x14, 0xc2c0}, {0x14, 0x60b0}, {0x14, 0xd705}, {0x14, 0x4071},
    {0x14, 0x8510}, {0x14, 0x2c38}, {0x14, 0xa510}, {0x14, 0xd704},
    {0x14, 0xd500}, {0x14, 0xd027}, {0x14, 0xd1a3}, {0x14, 0xc450},
    {0x14, 0xc100}, {0x14, 0xc840}, {0x14, 0xc000}, {0x14, 0xd704},
    {0x14, 0x401a}, {0x14, 0x8342}, {0x14, 0x1479}, {0x14, 0xd700},
    {0x14, 0x324b}, {0x14, 0x1c53}, {0x14, 0xd71e}, {0x14, 0x6169},
    {0x14, 0xd704}, {0x14, 0x3149}, {0x14, 0x5c4c}, {0x14, 0xd705},
    {0x14, 0x3251}, {0x14, 0x1c40}, {0x14, 0xd704}, {0x14, 0x606d},
    {0x14, 0x3288}, {0x14, 0x3c40}, {0x14, 0xd501}, {0x14, 0xa220},
    {0x14, 0xd500}, {0x14, 0xc451}, {0x14, 0xd04c}, {0x14, 0xd1a7},
    {0x14, 0xd704}, {0x14, 0x401a}, {0x14, 0xa342}, {0x14, 0xd502},
    {0x14, 0x8301}, {0x14, 0x8240}, {0x14, 0xd501}, {0x14, 0xc2a3},
    {0x14, 0xd500}, {0x14, 0xc452}, {0x14, 0xd027}, {0x14, 0xd1a3},
    {0x14, 0xd027}, {0x14, 0xd1b3}, {0x14, 0x401a}, {0x14, 0x8342},
    {0x14, 0x5fdb}, {0x14, 0xd501}, {0x14, 0xa210}, {0x14, 0xd500},
    {0x14, 0xc453}, {0x14, 0xd04e}, {0x14, 0xd1c3}, {0x14, 0x401c},
    {0x14, 0xd502}, {0x14, 0x8220}, {0x14, 0xd500}, {0x14, 0xc454},
    {0x14, 0xd700}, {0x14, 0x4132}, {0x14, 0x15a8}, {0x14, 0xd70c},
    {0x14, 0x40c0}, {0x14, 0xd704}, {0x14, 0xd07a}, {0x14, 0xd1b3},
    {0x14, 0x401b}, {0x14, 0x15a8}, {0x14, 0x9404}, {0x14, 0xd71e},
    {0x14, 0x6129}, {0x14, 0xd704}, {0x14, 0x60f3}, {0x14, 0xd705},
    {0x14, 0x7152}, {0x14, 0xd704}, {0x14, 0x606d}, {0x14, 0x3288},
    {0x14, 0x3c0f}, {0x14, 0x20e8}, {0x14, 0xd705}, {0x14, 0x3231},
    {0x14, 0x0d38}, {0x14, 0xd704}, {0x14, 0x60c5}, {0x14, 0xd700},
    {0x14, 0x33b9}, {0x14, 0x0c9e}, {0x14, 0x62d8}, {0x14, 0x2d38},
    {0x14, 0x60a6}, {0x14, 0xd700}, {0x14, 0x404c}, {0x14, 0xb401},
    {0x14, 0x2ce5}, {0x14, 0xd700}, {0x14, 0x604c}, {0x14, 0xb401},
    {0x14, 0x2cc2}, {0x14, 0xb240}, {0x14, 0xd709}, {0x14, 0x3001},
    {0x14, 0x5c90}, {0x14, 0xd700}, {0x14, 0x7da8}, {0x14, 0x3127},
    {0x14, 0x1c90}, {0x14, 0x604c}, {0x14, 0xb401}, {0x14, 0x2cc2},
    {0x14, 0xd302}, {0x14, 0xd705}, {0x14, 0x6052}, {0x14, 0xb280},
    {0x14, 0xd700}, {0x14, 0x416c}, {0x14, 0xd709}, {0x14, 0x3001},
    {0x14, 0x5cc2}, {0x14, 0xd700}, {0x14, 0x61e8}, {0x14, 0x3127},
    {0x14, 0x1cc2}, {0x14, 0x419e}, {0x14, 0xb401}, {0x14, 0x2ce5},
    {0x14, 0xd709}, {0x14, 0x3001}, {0x14, 0x5ce5}, {0x14, 0xd700},
    {0x14, 0x6508}, {0x14, 0x3127}, {0x14, 0x1ce5}, {0x14, 0x64be},
    {0x14, 0xb401}, {0x14, 0xd700}, {0x14, 0x4190}, {0x14, 0xd709},
    {0x14, 0x3006}, {0x14, 0x1cc8}, {0x14, 0x40c7}, {0x14, 0xd700},
    {0x14, 0x8380}, {0x14, 0xd014}, {0x14, 0xd1a3}, {0x14, 0x401a},
    {0x14, 0xd502}, {0x14, 0xa120}, {0x14, 0xd701}, {0x14, 0xd500},
    {0x14, 0xa301}, {0x14, 0xd501}, {0x14, 0x60e5}, {0x14, 0xe00f},
    {0x14, 0x0609}, {0x14, 0xd500}, {0x14, 0xe00c}, {0x14, 0x0b08},
    {0x14, 0x2cdb}, {0x14, 0xa608}, {0x14, 0xd502}, {0x14, 0x8120},
    {0x14, 0xd700}, {0x14, 0xd501}, {0x14, 0x3061}, {0x14, 0x1ce4},
    {0x14, 0x6062}, {0x14, 0x4040}, {0x14, 0x2ce4}, {0x14, 0x2d07},
    {0x14, 0xd700}, {0x14, 0x4190}, {0x14, 0xd709}, {0x14, 0x3006},
    {0x14, 0x1ceb}, {0x14, 0x40c7}, {0x14, 0xd700}, {0x14, 0x8380},
    {0x14, 0xd014}, {0x14, 0xd1a3}, {0x14, 0x401a}, {0x14, 0xd502},
    {0x14, 0xa120}, {0x14, 0xd701}, {0x14, 0xd500}, {0x14, 0x8301},
    {0x14, 0xd501}, {0x14, 0x60e5}, {0x14, 0xe00f}, {0x14, 0x0602},
    {0x14, 0xd500}, {0x14, 0xe00c}, {0x14, 0x0b0c}, {0x14, 0x2cfe},
    {0x14, 0x8608}, {0x14, 0xd502}, {0x14, 0x8120}, {0x14, 0xd700},
    {0x14, 0xd501}, {0x14, 0x3061}, {0x14, 0x1d07}, {0x14, 0x6062},
    {0x14, 0x4040}, {0x14, 0x2d07}, {0x14, 0xd500}, {0x14, 0x4230},
    {0x14, 0xd704}, {0x14, 0x40c5}, {0x14, 0xd705}, {0x14, 0x4090},
    {0x14, 0x9840}, {0x14, 0xd71e}, {0x14, 0x6007}, {0x14, 0x9810},
    {0x14, 0xd71e}, {0x14, 0x6005}, {0x14, 0xd700}, {0x14, 0xa208},
    {0x14, 0xd027}, {0x14, 0xd1a3}, {0x14, 0x401a}, {0x14, 0x8208},
    {0x14, 0x43f8}, {0x14, 0xb404}, {0x14, 0x30e8}, {0x14, 0x5d1f},
    {0x14, 0xa920}, {0x14, 0x2d20}, {0x14, 0x8920}, {0x14, 0xa330},
    {0x14, 0xd076}, {0x14, 0xd188}, {0x14, 0xd03b}, {0x14, 0xd198},
    {0x14, 0x3220}, {0x14, 0x3d38}, {0x14, 0xd024}, {0x14, 0xd18b},
    {0x14, 0xd012}, {0x14, 0xd19b}, {0x14, 0x41b1}, {0x14, 0xd07a},
    {0x14, 0xd189}, {0x14, 0xd03d}, {0x14, 0xd199}, {0x14, 0xd705},
    {0x14, 0x40f2}, {0x14, 0xd70c}, {0x14, 0x40a0}, {0x14, 0xd0f4},
    {0x14, 0xd187}, {0x14, 0xd07a}, {0x14, 0xd197}, {0x14, 0xd700},
    {0x14, 0x9401}, {0x14, 0x0800}, {0x14, 0xd705}, {0x14, 0x3251},
    {0x14, 0x1535}, {0x14, 0xd704}, {0x14, 0x252e}, {0x13, 0xa01a},
    {0x14, 0x0000}, {0x13, 0xa006}, {0x14, 0x052b}, {0x13, 0xa004},
    {0x14, 0x052b}, {0x13, 0xa002}, {0x14, 0x0479}, {0x13, 0xa000},
    {0x14, 0x7076}, {0x13, 0xb820}, {0x14, 0x0010}, {0x1f, 0x0a43},
    {0x13, 0x8368}, {0x14, 0xaf83}, {0x14, 0x74af}, {0x14, 0x838c},
    {0x14, 0xaf83}, {0x14, 0x9baf}, {0x14, 0x83a4}, {0x14, 0x0719},
    {0x14, 0xd907}, {0x14, 0xbf3a}, {0x14, 0x2f02}, {0x14, 0x373c},
    {0x14, 0x0719}, {0x14, 0xd907}, {0x14, 0xbf3a}, {0x14, 0x2c02},
    {0x14, 0x373c}, {0x14, 0x07af}, {0x14, 0x0e1a}, {0x14, 0xad31},
    {0x14, 0x0302}, {0x14, 0x83f7}, {0x14, 0xad32}, {0x14, 0x0302},
    {0x14, 0x84d1}, {0x14, 0xaf19}, {0x14, 0x5202}, {0x14, 0x847e},
    {0x14, 0x0284}, {0x14, 0xb7af}, {0x14, 0x0354}, {0x14, 0xe6ff},
    {0x14, 0xf701}, {0x14, 0x03af}, {0x14, 0x01e0}, {0x14, 0xee80},
    {0x14, 0x127f}, {0x14, 0x0285}, {0x14, 0x9dee}, {0x14, 0x8073},
    {0x14, 0x14ee}, {0x14, 0x807e}, {0x14, 0xffee}, {0x14, 0x8087},
    {0x14, 0xffee}, {0x14, 0x8090}, {0x14, 0x55ee}, {0x14, 0x8099},
    {0x14, 0x55ee}, {0x14, 0x809a}, {0x14, 0x89ee}, {0x14, 0x809b},
    {0x14, 0x11ee}, {0x14, 0x80a0}, {0x14, 0x00ee}, {0x14, 0x80a2},
    {0x14, 0xffee}, {0x14, 0x80a3}, {0x14, 0x92ee}, {0x14, 0x80a4},
    {0x14, 0x33ee}, {0x14, 0x80a9}, {0x14, 0x22ee}, {0x14, 0x80ab},
    {0x14, 0xffee}, {0x14, 0x80b4}, {0x14, 0xffd2}, {0x14, 0x0002},
    {0x14, 0x0cdc}, {0x14, 0x0284}, {0x14, 0xae02}, {0x14, 0x849c},
    {0x14, 0x04f8}, {0x14, 0xe082}, {0x14, 0xf2a0}, {0x14, 0x0005},
    {0x14, 0x0284}, {0x14, 0x0dae}, {0x14, 0x08a0}, {0x14, 0x0105},
    {0x14, 0x0284}, {0x14, 0x54ae}, {0x14, 0x00fc}, {0x14, 0x04f8},
    {0x14, 0xfaef}, {0x14, 0x69e0}, {0x14, 0x8239}, {0x14, 0xf621},
    {0x14, 0xe482}, {0x14, 0x39bf}, {0x14, 0x3966}, {0x14, 0x0237},
    {0x14, 0x7ae5}, {0x14, 0x82f3}, {0x14, 0xe080}, {0x14, 0x12ad},
    {0x14, 0x2427}, {0x14, 0xe082}, {0x14, 0xf3ad}, {0x14, 0x2019},
    {0x14, 0xe082}, {0x14, 0x37f7}, {0x14, 0x21e4}, {0x14, 0x8237},
    {0x14, 0xe082}, {0x14, 0x54f7}, {0x14, 0x21e4}, {0x14, 0x8254},
    {0x14, 0x023b}, {0x14, 0xa9ee}, {0x14, 0x82f2}, {0x14, 0x01ae},
    {0x14, 0x08d1}, {0x14, 0x00bf}, {0x14, 0x85d2}, {0x14, 0x0237},
    {0x14, 0x3cef}, {0x14, 0x69fe}, {0x14, 0xfc04}, {0x14, 0xf8fb},
    {0x14, 0x023b}, {0x14, 0xcead}, {0x14, 0x501f}, {0x14, 0xd101},
    {0x14, 0xbf85}, {0x14, 0xd202}, {0x14, 0x373c}, {0x14, 0xe082},
    {0x14, 0x54f6}, {0x14, 0x21e4}, {0x14, 0x8254}, {0x14, 0x023b},
    {0x14, 0xa9e0}, {0x14, 0x8237}, {0x14, 0xf621}, {0x14, 0xe482},
    {0x14, 0x37ee}, {0x14, 0x82f2}, {0x14, 0x00ff}, {0x14, 0xfc04},
    {0x14, 0xf8fa}, {0x14, 0xef69}, {0x14, 0xbf39}, {0x14, 0x6602},
    {0x14, 0x377a}, {0x14, 0xe082}, {0x14, 0xf31f}, {0x14, 0x019e},
    {0x14, 0x08e0}, {0x14, 0x8239}, {0x14, 0xf721}, {0x14, 0xe482},
    {0x14, 0x39ef}, {0x14, 0x96fe}, {0x14, 0xfc04}, {0x14, 0xf8fa},
    {0x14, 0xef69}, {0x14, 0xbf39}, {0x14, 0x6602}, {0x14, 0x377a},
    {0x14, 0xe582}, {0x14, 0xf3ef}, {0x14, 0x96fe}, {0x14, 0xfc04},
    {0x14, 0xee87}, {0x14, 0xfe44}, {0x14, 0xee87}, {0x14, 0xff44},
    {0x14, 0x04f8}, {0x14, 0xfaef}, {0x14, 0x69bf}, {0x14, 0x85cf},
    {0x14, 0x0237}, {0x14, 0x7aad}, {0x14, 0x2808}, {0x14, 0xe082},
    {0x14, 0x39f7}, {0x14, 0x22e4}, {0x14, 0x8239}, {0x14, 0xef96},
    {0x14, 0xfefc}, {0x14, 0x04f8}, {0x14, 0xfaef}, {0x14, 0x69e0},
    {0x14, 0x8239}, {0x14, 0xf622}, {0x14, 0xe482}, {0x14, 0x39e0},
    {0x14, 0x8012}, {0x14, 0xad26}, {0x14, 0x22bf}, {0x14, 0x3885},
    {0x14, 0x0237}, {0x14, 0x7aad}, {0x14, 0x2819}, {0x14, 0xbf85},
    {0x14, 0xcc02}, {0x14, 0x377a}, {0x14, 0xac28}, {0x14, 0x0802},
    {0x14, 0x8512}, {0x14, 0x0285}, {0x14, 0x32ae}, {0x14, 0x08e0},
    {0x14, 0x87ff}, {0x14, 0xe187}, {0x14, 0xfeae}, {0x14, 0xf3d1},
    {0x14, 0x00bf}, {0x14, 0x85cf}, {0x14, 0x0237}, {0x14, 0x3cef},
    {0x14, 0x96fe}, {0x14, 0xfc04}, {0x14, 0xf9fa}, {0x14, 0xef69},
    {0x14, 0xe287}, {0x14, 0xfd4a}, {0x14, 0x09bf}, {0x14, 0x8076},
    {0x14, 0x1a92}, {0x14, 0xdaef}, {0x14, 0x020c}, {0x14, 0x0158},
    {0x14, 0x705a}, {0x14, 0x071e}, {0x14, 0x0219}, {0x14, 0xd9ef},
    {0x14, 0x96fe}, {0x14, 0xfd04}, {0x14, 0xf8f9}, {0x14, 0xfaef},
    {0x14, 0x69fa}, {0x14, 0xfbbf}, {0x14, 0x8567}, {0x14, 0xd600},
    {0x14, 0x0002}, {0x14, 0x856f}, {0x14, 0xad50}, {0x14, 0x02f7},
    {0x14, 0x40a9}, {0x14, 0x856d}, {0x14, 0x06a6}, {0x14, 0x000f},
    {0x14, 0x0cae}, {0x14, 0x0e0f}, {0x14, 0x44d2}, {0x14, 0x021a},
    {0x14, 0x920c}, {0x14, 0x61ae}, {0x14, 0xe40f}, {0x14, 0x44ae},
    {0x14, 0xdaff}, {0x14, 0xfeef}, {0x14, 0x96fe}, {0x14, 0xfdfc},
    {0x14, 0x043a}, {0x14, 0x473a}, {0x14, 0x4a3a}, {0x14, 0x3e3a},
    {0x14, 0x41f8}, {0x14, 0xf9fa}, {0x14, 0xef69}, {0x14, 0xda19},
    {0x14, 0xdbef}, {0x14, 0x95ef}, {0x14, 0x7959}, {0x14, 0x0fef},
    {0x14, 0x2102}, {0x14, 0x377a}, {0x14, 0x1b21}, {0x14, 0x9e0f},
    {0x14, 0xab03}, {0x14, 0x81ae}, {0x14, 0x0111}, {0x14, 0xef97},
    {0x14, 0x0237}, {0x14, 0x3cf6}, {0x14, 0x50ae}, {0x14, 0x02f7},
    {0x14, 0x50ef}, {0x14, 0x96fe}, {0x14, 0xfdfc}, {0x14, 0x04f8},
    {0x14, 0xf9fa}, {0x14, 0xcefa}, {0x14, 0xef69}, {0x14, 0xfbbf},
    {0x14, 0x85c8}, {0x14, 0xd700}, {0x14, 0x04d8}, {0x14, 0x19d9},
    {0x14, 0x19da}, {0x14, 0x19db}, {0x14, 0x1907}, {0x14, 0xef95},
    {0x14, 0x0237}, {0x14, 0x3c07}, {0x14, 0x3f00}, {0x14, 0x049f},
    {0x14, 0xecff}, {0x14, 0xef96}, {0x14, 0xfec6}, {0x14, 0xfefd},
    {0x14, 0xfc04}, {0x14, 0x001a}, {0x14, 0x3b3d}, {0x14, 0x00a4},
    {0x14, 0x4011}, {0x14, 0xa440}, {0x14, 0x22a4}, {0x14, 0x6c11},
    {0x14, 0xa46c}, {0x13, 0xb818}, {0x14, 0x0e19}, {0x13, 0xb81a},
    {0x14, 0x194c}, {0x13, 0xb81c}, {0x14, 0x0351}, {0x13, 0xb81e},
    {0x14, 0x01dd}, {0x13, 0xb820}, {0x14, 0x000f}, {0x1f, 0x0a43},
    {0x13, 0x0000}, {0x14, 0x0000}, {0x1f, 0x0b82}, {0x17, 0x0000},
    {0x1f, 0x0a43}, {0x13, 0x8146}, {0x14, 0x0000}, {0x11, 0x0243},
#endif
    {0x1d, 0x0000},
    };
#endif

#if defined(CONFIG_RTL8380)
confcode_prv_t rtl8214fc_0455B_rtl8380_perchip[] = {
    {0, 0x1f, 0x0000},{0, 0x1d, 0x0008},{0, 0x1f, 0x0460},{0, 0x10, 0x5800},\
    {0, 0x11, 0x4000},{0, 0x12, 0x5400},{0, 0x13, 0x7ffb},{0, 0x14, 0x001f},\
    {0, 0x15, 0x60c1},{0, 0x16, 0x60c1},{0, 0x17, 0xffff},{0, 0x1f, 0x0461},\
    {0, 0x10, 0xffff},{0, 0x11, 0xcc6f},{0, 0x12, 0x1004},{0, 0x13, 0x14a5},\
    {0, 0x14, 0xf514},{0, 0x15, 0x0514},{0, 0x16, 0x8a41},{0, 0x17, 0x48c0},\
    {0, 0x1f, 0x0462},{0, 0x10, 0xf216},{0, 0x11, 0xf04a},{0, 0x12, 0x97b3},\
    {0, 0x13, 0x5318},{0, 0x14, 0x0f03},{0, 0x15, 0xc814},{0, 0x16, 0x7860},\
    {0, 0x17, 0xbdef},{0, 0x1f, 0x0463},{0, 0x10, 0xffff},{0, 0x11, 0xc60a},\
    {0, 0x12, 0xa052},{0, 0x13, 0x00f5},{0, 0x14, 0x4205},{0, 0x15, 0x7e19},\
    {0, 0x16, 0x44a2},{0, 0x17, 0xc3e0},{0, 0x1f, 0x0464},{0, 0x10, 0x601c},\
    {0, 0x11, 0xc9ae},{0, 0x12, 0x3fe0},{0, 0x13, 0x3e50},{0, 0x14, 0xffff},\
    {0, 0x15, 0x7803},{0, 0x16, 0x007a},{0, 0x17, 0x04f5},{0, 0x1f, 0x0465},\
    {0, 0x10, 0x41ff},{0, 0x11, 0x39ff},{0, 0x12, 0x4010},{0, 0x13, 0x007f},\
    {0, 0x14, 0x619f},{0, 0x15, 0x29fb},{0, 0x16, 0x7f60},{0, 0x1f, 0x0467},\
    {0, 0x16, 0x060b},{0, 0x14, 0xfe3d},{0, 0x14, 0xfe3f},{0, 0x1f, 0x0405},\
    {0, 0x14, 0x08ec},{0, 0x1f, 0x042c},{0, 0x10, 0xc803},{0, 0x11, 0x4000},\
    {0, 0x14, 0xd588},{0, 0x1f, 0x042d},{0, 0x16, 0x201f},{0, 0x1f, 0x044c},\
    {0, 0x10, 0xc803},{0, 0x11, 0x4000},{0, 0x14, 0xd588},{0, 0x1f, 0x044d},\
    {0, 0x16, 0x201f},{0, 0x1f, 0x0467},{0, 0x14, 0xfe0f},{0, 0x14, 0xfe3f},\
    {0, 0x1f, 0x0405},{0, 0x12, 0x0fa4},{0, 0x1f, 0x040a},{0, 0x10, 0x0616},\
    {0, 0x1f, 0x0425},{0, 0x12, 0x0fa4},{0, 0x1f, 0x042a},{0, 0x10, 0x0616},\
    {0, 0x1f, 0x0278},{0, 0x12, 0x0455},\
    {0, 0x1f, 0x0268},{0, 0x16, 0x0014},{0, 0x1f, 0x0260},{0, 0x14, 0x032e},\
    {0, 0x15, 0x00f0},{0, 0x1f, 0x0261},{0, 0x10, 0x300f},{0, 0x1f, 0x0266},\
    {0, 0x10, 0x0395},{0, 0x13, 0x0395},{0, 0x14, 0x0395},{0, 0x15, 0x0395},\
    {0, 0x1f, 0x0000},{0, 0x1d, 0x0000},\
    };

confcode_rv_t rtl8214fc_0455B_rtl8380_perport[] = {\
  //####Set patch_key & patch_lock#####
  {0x1f, 0x0000},{0x1b, 0x8146},{0x1c, 0x5501},{0x1b, 0xb82e},\
  {0x1c, 0x0001},\
  //#nc_patch.0371B.121022.txamp.cfg
  {0x1f, 0x0000},{0x1b, 0xb820},{0x1c, 0x0090},{0x1b, 0xa012},\
  {0x1c, 0x0000},{0x1b, 0xa014},{0x1c, 0x2c04},{0x1c, 0x2c0e},\
  {0x1c, 0x2c12},{0x1c, 0x2c13},{0x1c, 0xcc00},{0x1c, 0x1c08},\
  {0x1c, 0xd502},{0x1c, 0x2359},{0x1c, 0xce20},{0x1c, 0xcf01},\
  {0x1c, 0xd705},{0x1c, 0x4005},{0x1c, 0xcf02},{0x1c, 0x0800},\
  {0x1c, 0x15b7},{0x1c, 0xcc02},{0x1c, 0x1c08},{0x1c, 0x2286},\
  {0x1c, 0x2894},{0x1b, 0xa01a},{0x1c, 0x0000},{0x1b, 0xa006},\
  {0x1c, 0x0fff},{0x1b, 0xa004},{0x1c, 0x0008},{0x1b, 0xa002},\
  {0x1c, 0x0285},{0x1b, 0xa000},{0x1c, 0x7358},{0x1b, 0xb820},\
  {0x1c, 0x0010},\
  //#uc_patch.0371B.121022.txamp.cfg
  {0x1f, 0x0000},{0x1b, 0x8368},{0x1c, 0xaf83},{0x1c, 0x74af},\
  {0x1c, 0x838c},{0x1c, 0xaf83},{0x1c, 0x95af},{0x1c, 0x8398},\
  {0x1c, 0x0719},{0x1c, 0xd907},{0x1c, 0xbf3a},{0x1c, 0x2f02},\
  {0x1c, 0x373c},{0x1c, 0x0719},{0x1c, 0xd907},{0x1c, 0xbf3a},\
  {0x1c, 0x2c02},{0x1c, 0x373c},{0x1c, 0x07af},{0x1c, 0x0e1a},\
  {0x1c, 0x0204},{0x1c, 0x9102},{0x1c, 0x843e},{0x1c, 0xaf04},\
  {0x1c, 0x1baf},{0x1c, 0x8395},{0x1c, 0x0106},{0x1c, 0xe081},\
  {0x1c, 0x48af},{0x1c, 0x329e},{0x1c, 0xee80},{0x1c, 0x127f},\
  {0x1c, 0xee80},{0x1c, 0x1508},{0x1c, 0x0283},{0x1c, 0xe9ee},\
  {0x1c, 0x8073},{0x1c, 0x14ee},{0x1c, 0x807e},{0x1c, 0xffee},\
  {0x1c, 0x8087},{0x1c, 0xffee},{0x1c, 0x8090},{0x1c, 0x55ee},\
  {0x1c, 0x8099},{0x1c, 0x55ee},{0x1c, 0x809a},{0x1c, 0x89ee},\
  {0x1c, 0x809b},{0x1c, 0x11ee},{0x1c, 0x80a0},{0x1c, 0x00ee},\
  {0x1c, 0x80a2},{0x1c, 0xffee},{0x1c, 0x80a3},{0x1c, 0x92ee},\
  {0x1c, 0x80a4},{0x1c, 0x33ee},{0x1c, 0x80a9},{0x1c, 0x22ee},\
  {0x1c, 0x80ab},{0x1c, 0xffee},{0x1c, 0x80b4},{0x1c, 0xffd2},\
  {0x1c, 0x0002},{0x1c, 0x0cdc},{0x1c, 0x04f8},{0x1c, 0xf9fa},\
  {0x1c, 0xcefa},{0x1c, 0xef69},{0x1c, 0xfbbf},{0x1c, 0x8414},\
  {0x1c, 0xd700},{0x1c, 0x04d8},{0x1c, 0x19d9},{0x1c, 0x19da},\
  {0x1c, 0x19db},{0x1c, 0x1907},{0x1c, 0xef95},{0x1c, 0x0237},\
  {0x1c, 0x3c07},{0x1c, 0x3f00},{0x1c, 0x049f},{0x1c, 0xecff},\
  {0x1c, 0xef96},{0x1c, 0xfec6},{0x1c, 0xfefd},{0x1c, 0xfc04},\
  {0x1c, 0x001a},{0x1c, 0x3b3d},{0x1c, 0xf8f9},{0x1c, 0xfaef},\
  {0x1c, 0x69e0},{0x1c, 0x8015},{0x1c, 0xad23},{0x1c, 0x15bf},\
  {0x1c, 0x3819},{0x1c, 0x0237},{0x1c, 0x7aac},{0x1c, 0x2a0c},\
  {0x1c, 0xac29},{0x1c, 0x04d2},{0x1c, 0x01ae},{0x1c, 0x02d2},\
  {0x1c, 0x0302},{0x1c, 0x0cdc},{0x1c, 0xef96},{0x1c, 0xfefd},\
  {0x1c, 0xfc04},{0x1c, 0xf8fa},{0x1c, 0xef69},{0x1c, 0xe082},\
  {0x1c, 0x3cac},{0x1c, 0x2511},{0x1c, 0xe082},{0x1c, 0x31ad},\
  {0x1c, 0x251b},{0x1c, 0x0284},{0x1c, 0x18d1},{0x1c, 0x01bf},\
  {0x1c, 0x382b},{0x1c, 0x0237},{0x1c, 0x3ce0},{0x1c, 0x823c},\
  {0x1c, 0xf625},{0x1c, 0xe482},{0x1c, 0x3ce0},{0x1c, 0x8231},\
  {0x1c, 0xf625},{0x1c, 0xe482},{0x1c, 0x31ef},{0x1c, 0x96fe},\
  {0x1c, 0xfc04},{0x1b, 0xb818},{0x1c, 0x0e19},{0x1b, 0xb81a},\
  {0x1c, 0x0418},{0x1b, 0xb81c},{0x1c, 0xfffd},{0x1b, 0xb81e},\
  {0x1c, 0x329b},{0x1b, 0xb820},{0x1c, 0x001b},\
  //#clear patch_key & patch_lock#####
  {0x1f, 0x0000},{0x1b, 0x0000},{0x1c, 0x0000},{0x1f, 0x0b82},\
  {0x17, 0x0000},{0x1f, 0x0000},{0x1b, 0x8146},{0x1c, 0x0000},\
  //#release patch request #########
  {0x1f, 0x0b82},{0x10, 0x000b},\
    };

confcode_prv_t rtl8214fc_6276A_rtl8380_perchip[] = {
    {0, 0x1f, 0x0000},{0, 0x1e, 0x0008},{0, 0x1f, 0x0405},{0, 0x14, 0x08ec},\
    {0, 0x1f, 0x0404},{0, 0x17, 0x5359},{0, 0x1f, 0x0424},{0, 0x17, 0x5359},\
    {0, 0x1f, 0x042c},{0, 0x11, 0x4000},{0, 0x12, 0x2020},\
     /*add for disable s0 ring*/
    {0, 0x1f, 0x040c},{0, 0x11, 0x4000},\
     /* end add 20130206*/
    {0, 0x1f, 0x0464},\
    {0, 0x13, 0x3def},{0, 0x15, 0x4c2a},{0, 0x1f, 0x0460},{0, 0x10, 0x4800},\
    {0, 0x1f, 0x0465},{0, 0x12, 0x40ff},{0, 0x1f, 0x0462},{0, 0x12, 0x9693},\
    {0, 0x13, 0x5308},{0, 0x15, 0x4d58},{0, 0x1f, 0x042E},{0, 0x11, 0x308d},\
    {0, 0x1f, 0x0464},{0, 0x17, 0x84f5},{0, 0x17, 0x04f5},{0, 0x1f, 0x042D},\
    {0, 0x11, 0xC015},{0, 0x11, 0xC014},{0, 0x1f, 0x0000},{0, 0x1e, 0x0000},\
    /*##--Combo Mode Fiber Port Patch
       ## fiber port enable N-way to force link (default is 0x0749) ## update 20130402 */
    {0, 0x1f, 0x0000},{0, 0x1e, 0x0008},{0, 0x1f, 0x0260},\
    {0, 0x13, 0x5820},\
    {0, 0x14, 0x032c},\
    {0, 0x1f, 0x0266},{0, 0x10, 0x0395},{0, 0x13, 0x0395},\
    {0, 0x14, 0x0395},{0, 0x15, 0x0395},{0, 0x1f, 0x0000},{0, 0x1e, 0x0000},\
    {0, 0x1f, 0x0000},{0, 0x1e, 0x0003},{0, 0x1f, 0x0008},{0, 0x17, 0x5359},{0, 0x14, 0x074d},\
    {0, 0x1f, 0x0000},{0, 0x1e, 0x0000},{1, 0x1f, 0x0000},{1, 0x1e, 0x0003},\
    {1, 0x1f, 0x0008},{1, 0x17, 0x5359},{1, 0x14, 0x074d},{1, 0x1f, 0x0000},{1, 0x1e, 0x0000},\
    {2, 0x1f, 0x0000},{2, 0x1e, 0x0003},{2, 0x1f, 0x0008},{2, 0x17, 0x5359},{2, 0x14, 0x074d},\
    {2, 0x1f, 0x0000},{2, 0x1e, 0x0000},{3, 0x1f, 0x0000},{3, 0x1e, 0x0003},\
    {3, 0x1f, 0x0008},{3, 0x17, 0x5359},{3, 0x14, 0x074d},{3, 0x1f, 0x0000},{3, 0x1e, 0x0000},\
    };

confcode_rv_t rtl8214fc_6276A_rtl8380_perport[] = {\
};

confcode_prv_t rtl8214fc_6276B_rtl8380_perchip[] =  {\
  {0, 0x1e, 0x0008},{0, 0x1f, 0x0405},{0, 0x14, 0x08ec},{0, 0x1f, 0x0404}, \
  {0, 0x17, 0x5359},{0, 0x1f, 0x0424},{0, 0x17, 0x5359},{0, 0x1f, 0x042c}, \
  {0, 0x11, 0x4000},{0, 0x12, 0x2020},{0, 0x17, 0x34ac},{0, 0x1f, 0x042d}, \
  {0, 0x12, 0x6078},{0, 0x1f, 0x042e},{0, 0x11, 0x2189},{0, 0x1f, 0x0460}, \
  {0, 0x10, 0x4800},{0, 0x1f, 0x0464},{0, 0x12, 0x1fb0},{0, 0x13, 0x3e0f}, \
  {0, 0x15, 0x202a},{0, 0x16, 0xf072},{0, 0x1f, 0x0465},{0, 0x10, 0x4208}, \
  {0, 0x11, 0x3a08},{0, 0x13, 0x8068},{0, 0x15, 0x29fb},{0, 0x12, 0x4007}, \
  {0, 0x14, 0x619f},{0, 0x1f, 0x0462},{0, 0x10, 0xf206},{0, 0x13, 0x530f}, \
  {0, 0x15, 0x2a58},{0, 0x12, 0x97b3},{0, 0x1f, 0x0464},{0, 0x17, 0x80f5}, \
  {0, 0x17, 0x00f5},{0, 0x1f, 0x042d},{0, 0x11, 0xc015},{0, 0x11, 0xc014}, \
  {0, 0x1f, 0x0467},{0, 0x14, 0x143d},{0, 0x14, 0x3c15},{0, 0x14, 0x3c17}, \
  {0, 0x14, 0x0000},{0, 0x1f, 0x0404},{0, 0x13, 0x7146},{0, 0x13, 0x7106}, \
  {0, 0x1f, 0x0424},{0, 0x13, 0x7146},{0, 0x13, 0x7106},{0, 0x1f, 0x0261}, \
  {0, 0x10, 0x6000},{0, 0x10, 0x0000},\
  {0, 0x1f, 0x0260},{0, 0x13, 0x5820},{0, 0x14, 0x032c},{0, 0x1f, 0x0280}, \
  {0, 0x10, 0xf0bb},{0, 0x1f, 0x0266},{0, 0x10, 0x0f95},{0, 0x13, 0x0f95}, \
  {0, 0x14, 0x0f95},{0, 0x15, 0x0f95},{0, 0x1f, 0x0a42},{0, 0x1e, 0x0000}, \
  {0, 0x1e, 0x0003},{0, 0x1f, 0x0008},{0, 0x17, 0x5359},{0, 0x14, 0x974d},\
  {0, 0x1e, 0x0000},{1, 0x1e, 0x0003},{1, 0x1f, 0x0008},{1, 0x17, 0x5359},\
  {1, 0x14, 0x974d},{1, 0x1e, 0x0000},{2, 0x1e, 0x0003},{2, 0x1f, 0x0008},\
  {2, 0x17, 0x5359},{2, 0x14, 0x974d},{2, 0x1e, 0x0000},{3, 0x1e, 0x0003},\
  {3, 0x1f, 0x0008},{3, 0x17, 0x5359},{3, 0x14, 0x974d},{3, 0x1e, 0x0000},\
  {0, 0x1e, 0x0001},{1, 0x1e, 0x0001},{2, 0x1e, 0x0001},{3, 0x1e, 0x0001},\
  {0, 0x00, 0x1340},{1, 0x00, 0x1340},{2, 0x00, 0x1340},{3, 0x00, 0x1340},\
  {0, 0x1e, 0x0003},{1, 0x1e, 0x0003},{2, 0x1e, 0x0003},{3, 0x1e, 0x0003},\
  {0, 0x1f, 0x0000},{1, 0x1f, 0x0000},{2, 0x1f, 0x0000},{3, 0x1f, 0x0000},\
  {0, 0x10, 0x1340},{1, 0x10, 0x1340},{2, 0x10, 0x1340},{3, 0x10, 0x1340},\
  {0, 0x1e, 0x0000},{1, 0x1e, 0x0000},{2, 0x1e, 0x0000},{3, 0x1e, 0x0000},\
  {0, 0x1f, 0x0a42},{1, 0x1f, 0x0a42},{2, 0x1f, 0x0a42},{3, 0x1f, 0x0a42},\
};

confcode_rv_t rtl8214fc_6276B_rtl8380_perport[] =  {\
  {0x1f, 0x0b82},{0x10, 0x0000},{0x1f, 0x0a44},{0x11, 0x0418},\
  {0x1f, 0x0bc0},{0x16, 0x0c00},{0x1f, 0x0a43},{0x11, 0x0043},\
  {0x1f, 0x0000},{0x1b, 0x809a},{0x1c, 0x8933},{0x1b, 0x80a3},\
  {0x1c, 0x9233},{0x1b, 0x80ac},{0x1c, 0xa444},{0x1b, 0x809f},\
  {0x1c, 0x6b20},{0x1b, 0x80a8},{0x1c, 0x6b22},{0x1b, 0x80b1},\
  {0x1c, 0x6b23},\
  /*8214FC fiber down speed patch*/
  {0x1f, 0x0000},{0x1e, 0x0003},{0x1f, 0x0003},{0x15, 0xe47f},\
  {0x1f, 0x0009},{0x15, 0x46f4},{0x1f, 0x0000},{0x1e, 0x0000},\
  /*End 8214FC fiber down speed patch*/
};

#endif



